/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/

package cnrg.itx.signal;

/**
 * This interface contains all the SIP error status codes.
 */
public interface ErrorResponse
{
	/***************** Request Failure ******************/
	
	/** Bad Request - request could not be understood due to malformed syntax **/
	public static final int BADREQUEST = 400;
	/** Unauthorized - requires user authentication**/
	public static final int UNAUTHORIZED = 401;
	/** Payment Required **/
	public static final int PAYREQUIRE = 402;
	/** Forbidden - authorization will not help **/
	public static final int FORBIDDEN = 403;
	/** Not Found - user does not exist at current domain **/
	public static final int NOTFOUND = 404;
	/** Method Not Allowed **/
	public static final int BADMETHOD = 405;
	/** Not Acceptable - responses have content not acceptable as specified by client making the request **/
	public static final int NOTACCEPT = 406;
	/** Proxy Authentication Required **/
	public static final int PROXYAUTHEN = 407;
	/** Request Timeout **/
	public static final int TIMEOUT = 408;
	/** Conflict - conflict with current state of resource **/
	public static final int CONFLICT = 409;
	/** Gone - requested resource is no longer available at server **/
	public static final int GONE = 410;
	/** Length Required - request needs a Content-Length **/
	public static final int LENGTHREQUIRE = 411;
	/** Request Entity Too Large **/
	public static final int REQUESTTOOBIG = 413;
	/** Request-URI Too Long **/
	public static final int URITOOBIG = 414;
	/** Unsupported Media Type **/
	public static final int BADMEDIA = 415;
	/** Bad Extension - extension in Require field could not be understood **/
	public static final int BADEXTENSION = 420;
	/** Temporarily Unavailable **/
	public static final int TEMPNOAVAIL = 480;
	/** Call Leg/Transaction Does Not Exist **/
	public static final int CALLLEGNOTEXIST = 481;
	/** Loop Detected **/
	public static final int LOOP = 482;
	/** Too Many Hops **/
	public static final int TOOMANYHOPS = 483;
	/** Address Incomplete **/
	public static final int INCMPLTADDRESS = 484;
	/** Ambiguous - the callee address was ambiguous **/
	public static final int AMBIGUOUS = 485;
	/** Busy Here **/
	public static final int BUSYHERE = 486;
	
	/***************** Server Failure ******************/
	
	/** Server Internal Error **/
	public static final int INTERNALERROR = 500;
	/** Not Implemented - the server lacks the functionality needed to fulfill the request **/
	public static final int NOIMPLEMENT = 501;
	/** Bad Gateway - acting as gateway or proxy, received an invalid response **/
	public static final int BADGATEWAY = 502;
	/** Service Unavailable **/
	public static final int SERVNOTAVAIL = 503;
	/** Gateway Time-out - when acting as a gateway **/
	public static final int GATETIMEOUT = 504;
	/** Version Not Supported **/
	public static final int BADSIPVERSION = 505;
	
	/***************** Global Failure ******************/
	
	/** Busy Everywhere **/
	public static final int BUSYEVERYWHERE = 600;
	/** Decline **/
	public static final int DECLINE = 603;
	/** Does Not Exist Anywhere **/
	public static final int NOTEXIST = 604;
	/** Not Acceptable **/
	public static final int NOTACCEPTABLE = 606;
}